/*
   This program shows how a Java program can open one file for
   input and another file for output and then just copy every
   line from the input file to the output file..

   Notice that this file does exactly the same thing as

   C:\> java RedirectStdInAndStdoutToFile

   This program also does exactly the same thing as

   C:\> java Echo < L50.txt > result.txt
*/
import java.util.Scanner;
import java.io.*;

public class EchoFromFileToFile
{
   public static void main(String[] args) throws FileNotFoundException
   {
      // Open the file L50.txt for reading.
      Scanner inFile = new Scanner( new FileInputStream( "L50.txt" ) );

      // Open the file result.txt for writing.
      PrintStream outFile = new PrintStream( new FileOutputStream( "result.txt" ) );

      // Echo every line of input from the inFile stream to the outFile stream.
      while ( inFile.hasNextLine() )
      {
         String oneLine = inFile.nextLine();
         // If you want to, you could manipulate (i.e., filter)
         // the line of input before sending it to stdout.
         outFile.println( oneLine );
      }
      outFile.close();
   }
}